//
//  ViewController.swift
//  UseMapKit
//
//  Created by Keith Welch on 9/13/15.
//  Copyright © 2015 Keith Welch. All rights reserved.
//

import UIKit
import MapKit
import CoreLocation
import AddressBook

class ViewController: UIViewController {

    @IBOutlet weak var txtAddress: UITextView!
    @IBOutlet var mapView: MKMapView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    @IBAction func btnDisplayMap(sender: AnyObject) {
        let geocoder = CLGeocoder()
        geocoder.geocodeAddressString(txtAddress.text, completionHandler: {(placemarks, error) -> Void in
            if (error != nil) {
                NSLog("Geocode failed with error: %@", error!)
                return
            }
            if((placemarks != nil) && (placemarks!.count > 0)) {
                let placemark:CLPlacemark = placemarks![0]
                self.mapView.centerCoordinate = placemark.location!.coordinate
                
                let region:MKCoordinateRegion = MKCoordinateRegionMakeWithDistance(self.mapView.centerCoordinate, 30000, 30000)
                
                self.mapView.setRegion(region, animated: true)

            }
        })
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }


}

