//
//  ViewController.swift
//  UseMKMapItem
//
//  Created by Keith Welch on 9/12/15.
//  Copyright © 2015 Keith Welch. All rights reserved.
//

import UIKit
import CoreLocation
import AddressBook
import MapKit

class ViewController: UIViewController {

    @IBOutlet weak var txtAddress: UITextView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }

    @IBAction func btnDisplayMap(sender: AnyObject) {
        let geocoder = CLGeocoder()
        geocoder.geocodeAddressString(txtAddress.text, completionHandler: {(placemarks, error) -> Void in
            if (error != nil) {
                NSLog("Geocode failed with error: %@", error!)
                return
            }
            if((placemarks != nil) && (placemarks!.count > 0)) {
                let placemark:CLPlacemark = placemarks![0]
                let location:CLLocation = placemark.location!
                
                let regionDistance:CLLocationDistance = 1000
                let coordinates = CLLocationCoordinate2DMake(location.coordinate.latitude, location.coordinate.longitude)
                let regionSpan = MKCoordinateRegionMakeWithDistance(coordinates, regionDistance, regionDistance)
                let options = [
                    MKLaunchOptionsMapCenterKey: NSValue(MKCoordinate: regionSpan.center),
                    MKLaunchOptionsMapSpanKey: NSValue(MKCoordinateSpan: regionSpan.span)
                ]
                let place = MKPlacemark(coordinate: coordinates, addressDictionary: nil)
                let mapItem = MKMapItem(placemark: place)
                mapItem.openInMapsWithLaunchOptions(options)
            }
        })
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }


}

