//
//  ViewController.swift
//  MapAnnotations
//
//  Created by Keith Welch on 12/6/15.
//  Copyright © 2015 Keith Welch. All rights reserved.
//

import UIKit
import MapKit
import CoreLocation
import AddressBook

class ViewController: UIViewController {

    @IBOutlet weak var txtAddress: UITextView!
    @IBOutlet weak var switchAnnotations: UISwitch!
    @IBOutlet weak var slideZoom: UISlider!
    @IBOutlet weak var mapView: MKMapView!
    
    var coord: CLLocationCoordinate2D!

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func btnGetMapTouched(sender: AnyObject) {
        let geocoder = CLGeocoder()
        geocoder.geocodeAddressString(txtAddress.text, completionHandler: {(placemarks, error) -> Void in
            if (error != nil) {
                NSLog("Geocode failed with error: %@", error!)
                return
            }
            if((placemarks != nil) && (placemarks!.count > 0)) {
                let placemark:CLPlacemark = placemarks![0]
                self.coord = placemark.location!.coordinate
                
                self.mapView.centerCoordinate = placemark.location!.coordinate
                self.SetZoom()
            }
        })
    }
    
    func SetZoom() {
        let meters: Double = (Double)(slideZoom.value * 30000)
        let region: MKCoordinateRegion = MKCoordinateRegionMakeWithDistance (coord, meters, meters);
        
        mapView.setRegion(region, animated:false)
    }

    @IBAction func switchAnnotationsChanged(sender: AnyObject) {
        if (switchAnnotations.on) {
            // we'll annotate the map center
            let annotationPoint1 = MKPointAnnotation()
            annotationPoint1.coordinate = coord
            annotationPoint1.title = "Apple";
            annotationPoint1.subtitle = "Apple headquarters";
            mapView.addAnnotation(annotationPoint1)
            
            // now another point
            let geocoder = CLGeocoder()
            geocoder.geocodeAddressString("1600 Amphitheatre Parkway Mountain View, CA 94043", completionHandler: {(placemarks, error) -> Void in
                if (error != nil) {
                    NSLog("Geocode failed with error: %@", error!)
                    return
                }
                if((placemarks != nil) && (placemarks!.count > 0)) {
                    let placemark:CLPlacemark = placemarks![0]
                    let annotationCoord = placemark.location!.coordinate
                    
                    let annotationPoint2 = MKPointAnnotation()
                    annotationPoint2.coordinate = annotationCoord
                    annotationPoint2.title = "Google";
                    annotationPoint2.subtitle = "Google headquarters";
                    self.mapView.addAnnotation(annotationPoint2)
                }
            })
        }
        else {
            mapView.removeAnnotations(mapView.annotations)
        }
    }
    
    @IBAction func slideZoomChanged(sender: AnyObject) {
        SetZoom()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

