//
//  ViewController.swift
//  IAds
//
//  Created by Keith Welch on 1/10/16.
//  Copyright © 2016 Keith Welch. All rights reserved.
//

import UIKit
import iAd

class ViewController: UIViewController, ADBannerViewDelegate {

    @IBOutlet weak var adBanner: ADBannerView!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        adBanner.hidden = true
        adBanner.delegate = self
    }
    
    // for positioning after rotation
    override func viewDidLayoutSubviews() {
        var contentFrame: CGRect = self.view.bounds
        var bannerFrame: CGRect = adBanner.frame
        contentFrame.size.height -= adBanner.frame.size.height
        bannerFrame.origin.y = contentFrame.size.height
        adBanner.frame = bannerFrame
    }

    func bannerViewActionShouldBegin(banner: ADBannerView!, willLeaveApplication willLeave: Bool) -> Bool {
        NSLog("bannerViewActionShouldBegin")
        return true
    }
    
    func bannerViewDidLoadAd(banner: ADBannerView!) {
        NSLog("bannerViewDidLoadAd")
        adBanner.hidden = false
    }
    
    func bannerView(banner: ADBannerView!, didFailToReceiveAdWithError error: NSError!) {
        NSLog("didFailToReceiveAdWithError")
    }
    
    func bannerViewActionDidFinish(banner: ADBannerView!) {
        NSLog("bannerViewActionDidFinish")
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

