//
//  ViewController.swift
//  FacebookPostWithSLRequest
//
//  Created by Keith Welch on 1/1/16.
//  Copyright © 2016 Keith Welch. All rights reserved.
//

import UIKit
import Accounts
import Social

class ViewController: UIViewController {

    @IBOutlet weak var txtPost: UITextView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }

    @IBAction func postMessage(sender: AnyObject) {
        PostMessage()
    }
    
    func PostMessage() {
        // Notes on AppIdKey:
        // Must register with Facebook for a developer account
        // After registering, create an iOS app in your account
        // Set it as iOS native, enter the Bundle ID
        let options = [
            ACFacebookAppIdKey:appID,
            ACFacebookPermissionsKey: ["publish_actions"], // for posting
            ACFacebookAudienceKey: ACFacebookAudienceFriends]

        let accountStore: ACAccountStore = ACAccountStore()
        let accountType: ACAccountType = accountStore.accountTypeWithAccountTypeIdentifier(ACAccountTypeIdentifierFacebook)
        
        accountStore.requestAccessToAccountsWithType(accountType, options: options as [NSObject : AnyObject], completion: {(granted, error) -> Void in
            if (granted)
            {
                let arrayOfAccounts: NSArray = accountStore.accountsWithAccountType(accountType)
                
                if (arrayOfAccounts.count > 0)
                {
                    let facebookAccount: ACAccount = arrayOfAccounts.lastObject as! ACAccount
                    
                    var message = Dictionary<String, AnyObject>()
                    message["message"] = self.txtPost.text
                    
                    let requestURL: NSURL = NSURL(string: "https://graph.facebook.com/me/feed")!
                    
                    let postRequest: SLRequest = SLRequest(forServiceType: SLServiceTypeFacebook, requestMethod: SLRequestMethod.POST, URL: requestURL, parameters: message)
                    
                    postRequest.account = facebookAccount
                    
                    postRequest.performRequestWithHandler({(responseData, urlResponse, error) ->
                        Void in
                    })
                }
            } else {
                self.GetInitialPermissions()
            }
        })
    }
    
    func GetInitialPermissions() {
        let options = [
            ACFacebookAppIdKey:appID,
            ACFacebookPermissionsKey: ["email"], // need a simple read permission first
            ACFacebookAudienceKey: ACFacebookAudienceFriends]
        
        let accountStore: ACAccountStore = ACAccountStore()
        let accountType: ACAccountType = accountStore.accountTypeWithAccountTypeIdentifier(ACAccountTypeIdentifierFacebook)
        
        accountStore.requestAccessToAccountsWithType(accountType, options: options as [NSObject : AnyObject], completion: {(granted, error) -> Void in
            if (granted)
            {
                self.PostMessage()
            }
        })
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }


    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    var appID: String! = "571561732999718"
}

