//
//  ViewController.swift
//  CurrentLocation
//
//  Created by Keith Welch on 9/13/15.
//  Copyright © 2015 Keith Welch. All rights reserved.
//

import UIKit
import CoreLocation

class ViewController: UIViewController, CLLocationManagerDelegate {

    @IBOutlet weak var lblLatitude: UILabel!
    @IBOutlet weak var lblLongitude: UILabel!
    @IBOutlet weak var lblAccuracy: UILabel!
    @IBOutlet weak var lblAltitude: UILabel!
    @IBOutlet weak var lblAltitudeAccuracy: UILabel!
    
    var locationManager:CLLocationManager!

    override func viewDidLoad() {
        super.viewDidLoad()

        locationManager = CLLocationManager()
        
        // Notes on accuracy:
        // kCLLocationAccuracyBestForNavigation – Highest accuracy augmented by additional sensor data.
        // kCLLocationAccuracyBest – Highest accuracy for running on battery.
        // kCLLocationAccuracyNearestTenMeters - 10 meters.
        // kCLLocationAccuracyHundredMeters – 100 meters.
        // kCLLocationAccuracyKilometer – 1 kilometer.
        // kCLLocationAccuracyThreeKilometers – 3 kilometers.
        locationManager.desiredAccuracy = kCLLocationAccuracyBest
        locationManager.delegate = self
    }
    
    @IBAction func btnGetLocationTouched(sender: AnyObject) {
        
        if (locationManager.respondsToSelector(Selector("requestWhenInUseAuthorization")))
        {
            locationManager.requestWhenInUseAuthorization()
        }
        locationManager.startUpdatingLocation()

    }
    
    func locationManager(manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {
        let newLocation:CLLocation = locations.last!
        
        lblLatitude.text = String(format: "Latitude = %+.6f", newLocation.coordinate.latitude)
        lblLongitude.text = String(format: "Longitude = %+.6f", newLocation.coordinate.longitude)
        lblAccuracy.text = String(format: "Accuracy = %+.6f", newLocation.horizontalAccuracy)
        lblAltitude.text = String(format: "Altitude = %+.6f", newLocation.altitude)
        lblAltitudeAccuracy.text = String(format: "Altitude Accuracy = %+.6f", newLocation.verticalAccuracy)
        
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

