//
//  Customer.swift
//  AccessingCloudKitData
//
//  Created by Keith Welch on 1/3/16.
//  Copyright © 2016 Keith Welch. All rights reserved.
//

import UIKit
import CloudKit

class Customer : NSObject{
    var record : CKRecord!
    var Address: String!
    var City: String!
    var State: String!
    var Name: String!
    weak var database : CKDatabase!

    init(record : CKRecord, database: CKDatabase) {
        self.record = record
        self.database = database
        self.Address = record.objectForKey("Address") as! String!
        self.City = record.objectForKey("City") as! String!
        self.State = record.objectForKey("State") as! String!
        self.Name = record.objectForKey("Name") as! String!
    }
}